//
//  GSGlyphsInfo+FeatureGenerator.h
//  GlyphsCore
//
//  Created by Georg Seifert on 30.09.12.
//  Copyright (c) 2012 schriftgestaltung.de. All rights reserved.
//
@class GSFont;
#import "MGOrderedDictionary.h"

@interface GSFeatureGenerator : NSObject {
	BOOL						updating;
	int						defaultFigures;
	NSDictionary				*commonLigs;
	NSDictionary				*_nonCombiningFeatures;
@private
	NSArray * _scripts;
}
+ (GSFeatureGenerator*) sharedManager;
/// Generates the OT features for the \a Font.
- (void) reset ;
- (void) makeFeatures:(GSFont *) Font ;
- (void) updateFeatureForTag:(NSString*) Tag forFont:(GSFont*) Font ;
- (void) updateClassForTag:(NSString*) Tag forFont:(GSFont*) Font ;
- (void) updatePrefixForTag:(NSString*) Tag forFont:(GSFont*) Font ;

+ (NSDictionary*) nonCombiningFeatures;

+ (NSString*) cleanMakeOTFErrormessage:(NSString*) ErrorMessage errorDescriptors:(NSMutableArray*) ErrorDescriptors path:(NSString*)Path;

@end
